<!doctype html>

<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" type="image/png" href="https://goride-landing.siswebapp.com/img/fav.png">
    <title><?php echo e(config('app.name','GoRide')); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap"rel="stylesheet">
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
</head>

<body class="fixed-bottom-bar">

    <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">
        <?php echo e(trans('lang.processing')); ?>

    </div>
    
    <div id="header-template"></div>
    
    <main id="body-template">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <div id="footer-template"></div>

    <script src="https://www.gstatic.com/firebasejs/8.0.0/firebase-app.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.0.0/firebase-firestore.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.0.0/firebase-storage.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.0.0/firebase-auth.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.0.0/firebase-database.js"></script>
    <script src="https://unpkg.com/geofirestore/dist/geofirestore.js"></script>
    <script src="https://cdn.firebase.com/libs/geofire/5.0.1/geofire.min.js"></script>
    <script type="text/javascript"><?php echo $__env->make('init_firebase', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></script>

    <script type="text/javascript">

        var database = firebase.firestore();

        var headerRef= database.collection('settings').doc('headerTemplate');
        var footerRef= database.collection('settings').doc('footerTemplate');
        
        $(document).ready(function () {

            jQuery("#data-table_processing").show();

            $(document.body).on('click', '.redirecttopage', function () {
                var url = $(this).attr('data-url');
                window.location.href = url;
            });

            header = document.getElementById('header-template');
            header.innerHTML = '';
            headerRef.get().then(async function (snapshots) {
                html = '';
                var data = snapshots.data();
                html = data.headerTemplate;
                if (html != '') {
                    header.innerHTML = html;
                }
            });

            footer = document.getElementById('footer-template');
            footer.innerHTML = '';

            footerRef.get().then(async function (snapshots) {
                html = '';
                var data = snapshots.data();
                html = data.footerTemplate;
                if (html != '') {
                    footer.innerHTML = html;
                }
                jQuery("#data-table_processing").hide();
            });

        });
    </script>

    <?php echo $__env->yieldContent('scripts'); ?>

</body>

</html><?php /**PATH /home/customer/www/goride-landing.siswebapp.com/public_html/resources/views/app.blade.php ENDPATH**/ ?>