# Firebase Admin PHP SDK

[![Current version](https://img.shields.io/packagist/v/kreait/firebase-php.svg?logo=composer)](https://packagist.org/packages/kreait/firebase-php)
[![Packagist PHP Version Support](https://img.shields.io/packagist/php-v/kreait/firebase-php)](https://packagist.org/packages/kreait/firebase-php)
[![Monthly Downloads](https://img.shields.io/packagist/dm/kreait/firebase-php.svg)](https://packagist.org/packages/kreait/firebase-php/stats)
[![Total Downloads](https://img.shields.io/packagist/dt/kreait/firebase-php.svg)](https://packagist.org/packages/kreait/firebase-php/stats)
[![Tests](https://github.com/kreait/firebase-php/actions/workflows/tests.yml/badge.svg)](https://github.com/kreait/firebase-php/actions/workflows/tests.yml)
[![Integration Tests](https://github.com/kreait/firebase-php/actions/workflows/integration-tests.yml/badge.svg)](https://github.com/kreait/firebase-php/actions/workflows/integration-tests.yml)
[![Emulator Tests](https://github.com/kreait/firebase-php/actions/workflows/emulator-tests.yml/badge.svg)](https://github.com/kreait/firebase-php/actions/workflows/emulator-tests.yml)
[![codecov](https://codecov.io/gh/kreait/firebase-php/branch/main/graph/badge.svg)](https://codecov.io/gh/kreait/firebase-php)
[![Sponsor](https://img.shields.io/static/v1?logo=GitHub&label=Sponsor&message=%E2%9D%A4&color=ff69b4)](https://github.com/sponsors/jeromegamez)

## Table of Contents

- [Overview](#overview)
- [Installation](#installation)
- [Documentation](#documentation)
- [Support](#support)
- [License](#license)

## Overview

[Firebase](https://firebase.google.com/) provides the tools and infrastructure you need to develop your app, grow your user base, and earn money. The Firebase Admin PHP SDK enables access to Firebase services from privileged environments (such as servers or cloud) in PHP.

For more information, visit the [Firebase Admin PHP SDK documentation](https://firebase-php.readthedocs.io/).

## Installation

The Firebase Admin PHP SDK is available on Packagist as [`kreait/firebase-php`](https://packagist.org/packages/kreait/firebase-php):

```bash
composer require kreait/firebase-php
```

Integrations for Laravel, Lumen and Symfony are available:

- [kreait/laravel-firebase](https://packagist.org/packages/kreait/laravel-firebase)
- [kreait/firebase-bundle](https://packagist.org/packages/kreait/firebase-bundle)

## Documentation

- [App Check Guide](https://firebase-php.readthedocs.io/en/stable/app-check.html)
- [Authentication Guide](https://firebase-php.readthedocs.io/en/stable/authentication.html)
- [Firestore Guide](https://firebase-php.readthedocs.io/en/stable/cloud-firestore.html)
- [Cloud Messaging Guide](https://firebase-php.readthedocs.io/en/stable/cloud-messaging.html)
- [Cloud Storage Guide](https://firebase-php.readthedocs.io/en/stable/cloud-storage.html)
- [Dynamic Links Guide](https://firebase-php.readthedocs.io/en/stable/dynamic-links.html)
- [Firestore Guide](https://firebase-php.readthedocs.io/en/stable/cloud-firestore.html)
- [Realtime Database Guide](https://firebase-php.readthedocs.io/en/stable/realtime-database.html)
- [Remote Config Guide](https://firebase-php.readthedocs.io/en/stable/remote-config.html)

## Support

- [Issue Tracker](https://github.com/kreait/firebase-php/issues/)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/firebase+php)

_If you or your team rely on this project and me maintaining it, please consider becoming a
[Sponsor](https://github.com/sponsors/jeromegamez/) 🙏. Higher tiers enable access to extended
support._

## License

Firebase Admin PHP SDK is licensed under the [MIT License](LICENSE).

Your use of Firebase is governed by the [Terms of Service for Firebase Services](https://firebase.google.com/terms/).
