<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\DriverController;
use App\Http\Controllers\IntercityServiceController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


    Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
    Route::get('lang/change', [App\Http\Controllers\LangController::class, 'change'])->name('changeLang');

    Route::get('/users', [App\Http\Controllers\UserController::class, 'index'])->name('users.index');
    Route::get('/users/edit/{id}', [App\Http\Controllers\UserController::class, 'edit'])->name('users.edit');
    Route::get('/users/profile', [App\Http\Controllers\UserController::class, 'profile'])->name('users.profile');
    Route::post('/users/profile/update/{id}', [App\Http\Controllers\UserController::class, 'update'])->name('users.profile.update');
    Route::get('/users/create', [App\Http\Controllers\UserController::class, 'create'])->name('users.create');
    Route::get('/users/view/{id}', [App\Http\Controllers\UserController::class, 'view'])->name('users.view');

    Route::get('/drivers', [App\Http\Controllers\DriverController::class, 'index'])->name('drivers');
    Route::get('/drivers/approved', [App\Http\Controllers\DriverController::class, 'index'])->name('drivers.approved');
    Route::get('/drivers/pending', [App\Http\Controllers\DriverController::class, 'index'])->name('drivers.pending');
    Route::get('/drivers/edit/{id}', [App\Http\Controllers\DriverController::class, 'edit'])->name('drivers.edit');
    Route::get('/drivers/create', [App\Http\Controllers\DriverController::class, 'create'])->name('drivers.create');
    Route::get('/drivers/view/{id}', [App\Http\Controllers\DriverController::class, 'view'])->name('drivers.view');
    Route::get('/drivers/document/{id}', [App\Http\Controllers\DriverController::class, 'driverDocuments'])->name('drivers.document');
    Route::get('/drivers/document/upload/{driverId}/{id}', [App\Http\Controllers\DriverController::class, 'driverDocumentUpload'])->name('drivers.document.upload');

    Route::get('/tax', [App\Http\Controllers\TaxController::class, 'index'])->name('tax');
    Route::get('/tax/edit/{id}', [App\Http\Controllers\TaxController::class, 'edit'])->name('tax.edit');
    Route::get('/tax/create', [App\Http\Controllers\TaxController::class, 'create'])->name('tax.create');

    Route::get('/services', [App\Http\Controllers\ServiceController::class, 'index'])->name('services');
    Route::get('/services/edit/{id}', [App\Http\Controllers\ServiceController::class, 'edit'])->name('services.edit');
    Route::get('/services/create', [App\Http\Controllers\ServiceController::class, 'create'])->name('services.create');

    Route::get('/coupons', [CouponController::class, 'index'])->name('coupons');
    Route::get('/coupons/deleted', [CouponController::class, 'deletedIndex'])->name('coupons.deleted.index');
    Route::get('/coupons/save/{id}', [CouponController::class, 'save'])->name('coupons.save');

    Route::get('/currency', [App\Http\Controllers\CurrencyController::class, 'index'])->name('currency');
    Route::get('/currency/edit/{id}', [App\Http\Controllers\CurrencyController::class, 'edit'])->name('currency.edit');
    Route::get('/currency/create', [App\Http\Controllers\CurrencyController::class, 'create'])->name('currency.create');

    Route::get('/vehicle-type', [App\Http\Controllers\VehicleTypeController::class, 'index'])->name('vehicle-type');
    Route::get('/vehicle-type/edit/{id}', [App\Http\Controllers\VehicleTypeController::class, 'edit'])->name('vehicle-type.edit');
    Route::get('/vehicle-type/create', [App\Http\Controllers\VehicleTypeController::class, 'create'])->name('vehicle-type.create');

    Route::get('/documents', [App\Http\Controllers\DocumentsController::class, 'index'])->name('documents');
    Route::get('/documents/deleted', [App\Http\Controllers\DocumentsController::class, 'deletedIndex'])->name('documents.deleted');
    Route::get('/documents/save/{id}', [App\Http\Controllers\DocumentsController::class, 'save'])->name('documents.save');
    Route::get('/documents/edit/{id}', [App\Http\Controllers\DocumentsController::class, 'edit'])->name('documents.edit');
    Route::get('/documents/create', [App\Http\Controllers\DocumentsController::class, 'create'])->name('documents.create');

    Route::get('/rides', [App\Http\Controllers\RidesController::class, 'index'])->name('rides');
    Route::get('/rides/show/{id}', [App\Http\Controllers\RidesController::class, 'show'])->name('rides.show');

    Route::get('/intercity-service', [App\Http\Controllers\IntercityServiceController::class, 'index'])->name('intercity-service');
    Route::get('/intercity-service/edit/{id}', [App\Http\Controllers\IntercityServiceController::class, 'edit'])->name('intercity-service.edit');

    Route::get('/intercity-service-rides', [IntercityServiceController::class, 'ridesList'])->name('intercity-service-rides');
    Route::get('/intercity-service-rides/view/{id}', [IntercityServiceController::class, 'rideView'])->name('intercity-service-rides.view');
    /*Route::get('/intercity-service/create', [App\Http\Controllers\IntercityServiceController::class, 'create'])->name('intercity-service.create');*/

    Route::get('/banners', [BannerController::class, 'index'])->name('banners');
    Route::get('/banners/deleted', [BannerController::class, 'deletedIndex'])->name('banners.deleted.index');
    Route::get('/banners/save/{id}', [BannerController::class, 'save'])->name('banners.save');

    Route::get('/reports/{type}', [ReportController::class, 'reportGenerate'])->name('reports');

    Route::get('cms', [App\Http\Controllers\CmsController::class, 'index'])->name('cms');
    Route::get('/cms/edit/{id}', [App\Http\Controllers\CmsController::class, 'edit'])->name('cms.edit');
    Route::get('/cms/create', [App\Http\Controllers\CmsController::class, 'create'])->name('cms.create');

    Route::get('/driver-rules', [DriverController::class, 'rulesIndex'])->name('driver-rules');
    Route::get('/driver-rules/deleted', [DriverController::class, 'deletedRulesIndex'])->name('driver-rules.deleted.index');
    Route::get('/driver-rules/save/{id}', [DriverController::class, 'saveRule'])->name('driver-rules.save');

    Route::get('/on-board', [App\Http\Controllers\OnBoardController::class, 'index'])->name('on-board');
    Route::get('/on-board/save/{id}', [App\Http\Controllers\OnBoardController::class, 'show'])->name('on-board.save');

    Route::get('/payoutRequest', [App\Http\Controllers\PayoutRequestController::class, 'index'])->name('payoutRequest.index');
    Route::get('/walletTransaction/user', [App\Http\Controllers\TransactionController::class, 'userWalletTransaction'])->name('walletTransaction.user');
    Route::get('/walletTransaction/driver', [App\Http\Controllers\TransactionController::class, 'driverWalletTranscation'])->name('walletTransaction.driver');

    Route::get('/faq', [App\Http\Controllers\FAQController::class, 'index'])->name('faq');
    Route::get('/faq/save/{id?}', [App\Http\Controllers\FAQController::class, 'save'])->name('faq.save');
    Route::get('/faq/deleted', [App\Http\Controllers\FAQController::class, 'deleted'])->name('faq.deleted');

    Route::post('send-notification', [App\Http\Controllers\NotificationController::class, 'sendNotification'])->name('send-notification');

    Route::get('sos', [App\Http\Controllers\SosController::class, 'sos'])->name('sos');
    Route::get('sos/edit/{id}', [App\Http\Controllers\SosController::class, 'sosEdit'])->name('sos.edit');

    Route::prefix('settings')->group(function () {
        Route::get('globals', [App\Http\Controllers\SettingsController::class, 'globals'])->name('settings.globals');
        Route::get('adminCommission', [App\Http\Controllers\SettingsController::class, 'adminCommission'])->name('settings.adminCommission');
        Route::get('payments/stripe', [App\Http\Controllers\SettingsController::class, 'stripe'])->name('settings.payments.stripe');
        Route::get('payments/applepay', [App\Http\Controllers\SettingsController::class, 'applepay'])->name('settings.payments.applepay');
        Route::get('payments/razorpay', [App\Http\Controllers\SettingsController::class, 'razorpay'])->name('settings.payments.razorpay');
        Route::get('payments/cod', [App\Http\Controllers\SettingsController::class, 'cod'])->name('settings.payments.cod');
        Route::get('payments/paypal', [App\Http\Controllers\SettingsController::class, 'paypal'])->name('settings.payments.paypal');
        Route::get('payments/paytm', [App\Http\Controllers\SettingsController::class, 'paytm'])->name('settings.payments.paytm');
        Route::get('payments/wallet', [App\Http\Controllers\SettingsController::class, 'wallet'])->name('settings.payments.wallet');
        Route::get('payments/payfast', [App\Http\Controllers\SettingsController::class, 'payfast'])->name('settings.payments.payfast');
        Route::get('payments/paystack', [App\Http\Controllers\SettingsController::class, 'paystack'])->name('settings.payments.paystack');
        Route::get('payments/flutterwave', [App\Http\Controllers\SettingsController::class, 'flutterwave'])->name('settings.payments.flutterwave');
        Route::get('payments/mercadopago', [App\Http\Controllers\SettingsController::class, 'mercadopago'])->name('settings.payments.mercadopago');
        Route::get('/landingPageTemplate', [App\Http\Controllers\SettingsController::class, 'landingPageTemplate'])->name('settings.landingPageTemplate');
        Route::get('/headerTemplate', [App\Http\Controllers\SettingsController::class, 'headerTemplate'])->name('settings.headerTemplate');
        Route::get('/footerTemplate', [App\Http\Controllers\SettingsController::class, 'footerTemplate'])->name('settings.footerTemplate');
        Route::get('/privacyPolicy', [App\Http\Controllers\SettingsController::class, 'privacyPolicy'])->name('settings.privacyPolicy');
        Route::get('/termsAndConditions', [App\Http\Controllers\SettingsController::class, 'termsAndConditions'])->name('settings.termsAndConditions');
        Route::get('/languages', [App\Http\Controllers\SettingsController::class, 'languages'])->name('settings.languages');
        Route::get('/languages/save/{id?}', [App\Http\Controllers\SettingsController::class, 'saveLanguage'])->name('settings.languages.save');
        Route::get('/languages/deleted', [App\Http\Controllers\SettingsController::class, 'deletedLang'])->name('settings.languages.deleted');

    });

    Route::get('/map', [App\Http\Controllers\MapController::class, 'index'])->name('map');
    Route::post('/map/get_ride_info', [App\Http\Controllers\MapController::class, 'getRideInfo'])->name('map.getrideinfo');
    Route::get('/freight-vehicles', [App\Http\Controllers\FreightVehicleController::class, 'index'])->name('freight-vehicle');
    Route::get('/freight-vehicles/save/{id?}', [App\Http\Controllers\FreightVehicleController::class, 'save'])->name('freight-vehicles.save');

    Route::get('/airports', [App\Http\Controllers\AirportsController::class, 'index'])->name('airports');
    Route::get('/airports/save/{id?}', [App\Http\Controllers\AirportsController::class, 'save'])->name('airport.save');


//API Url for app
Route::post('payments/getpaytmchecksum', [App\Http\Controllers\PaymentController::class, 'getPaytmChecksum']);
Route::post('payments/validatechecksum', [App\Http\Controllers\PaymentController::class, 'validateChecksum']);
Route::post('payments/initiatepaytmpayment', [App\Http\Controllers\PaymentController::class, 'initiatePaytmPayment']);
Route::get('payments/paytmpaymentcallback', [App\Http\Controllers\PaymentController::class, 'paytmPaymentcallback']);
Route::post('payments/paypalclientid', [App\Http\Controllers\PaymentController::class, 'getPaypalClienttoken']);
Route::post('payments/paypaltransaction', [App\Http\Controllers\PaymentController::class, 'createBraintreePayment']);
Route::post('payments/stripepaymentintent', [App\Http\Controllers\PaymentController::class, 'createStripePaymentIntent']);
Route::get('payment/success', [App\Http\Controllers\PaymentController::class, 'paymentsuccess'])->name('payment.success');
Route::get('payment/failed', [App\Http\Controllers\PaymentController::class, 'paymentfailed'])->name('payment.failed');
Route::get('payment/pending', [App\Http\Controllers\PaymentController::class, 'paymentpending'])->name('payment.pending');