<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Spatie\Permission\Exceptions\UnauthorizedException;
use Auth;

class PermissionMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $permission = null, $guard = null)
    {

        if (Auth::user()->getRoleNames()[0] == "Administrator") {
            return $next($request);
        }

        $authGuard = app('auth')->guard($guard);

        if ($authGuard->guest()) {
            throw UnauthorizedException::notLoggedIn();
        }

        if (!is_null($permission)) {
            $permissions = is_array($permission)
                ? $permission
                : explode('|', $permission);
        }

        if (is_null($permission)) {
            $permission = $request->route()->getName();
            $permissions = array($permission);
        }

        foreach ($permissions as $permission) {

            if (!empty($permission) && str_contains($permission, '.')) {

                list($name, $action) = explode('.', $permission, 2);

                if ($name == "payment" || $name == "wallet" || $name == "notifications" || $name == "dashboard" || $name == "language") {
                    return $next($request);
                }
            } else {

                if ($permission == "dashboard") {
                    return $next($request);
                }
            }

            if ($authGuard->user()->can($permission)) {
                return $next($request);
            }
        }

        throw UnauthorizedException::forPermissions($permissions);
    }
}